/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.util.List;
import javax.annotation.Nullable;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.AbstractIndexedIterator;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.ObjectArrays;
import org.python.google.common.collect.UnmodifiableListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
abstract class TransformedImmutableList<D, E>
extends ImmutableList<E> {
    private final transient ImmutableList<D> backingList;

    TransformedImmutableList(ImmutableList<D> immutableList) {
        this.backingList = Preconditions.checkNotNull(immutableList);
    }

    abstract E transform(D var1);

    @Override
    public int indexOf(@Nullable Object object) {
        if (object == null) {
            return -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        if (object == null) {
            return -1;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.get(i).equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public E get(int n) {
        return this.transform(this.backingList.get(n));
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int n) {
        Preconditions.checkPositionIndex(n, this.size());
        return new AbstractIndexedIterator<E>(n, this.size()){

            @Override
            protected E get(int n) {
                return TransformedImmutableList.this.get(n);
            }
        };
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public ImmutableList<E> subList(int n, int n2) {
        return new TransformedView(this.backingList.subList(n, n2));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            return this.size() == list.size() && Iterators.elementsEqual(this.iterator(), list.iterator());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (Object e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    public Object[] toArray() {
        return ObjectArrays.toArrayImpl(this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return ObjectArrays.toArrayImpl(this, TArray);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformedView
    extends TransformedImmutableList<D, E> {
        TransformedView(ImmutableList<D> immutableList) {
            super(immutableList);
        }

        @Override
        E transform(D d) {
            return TransformedImmutableList.this.transform(d);
        }
    }
}

